; *** Dinamic Help v0.4.4b.au3 ***
#Region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Icon=DH.ico
#EndRegion ;**** Directives created by AutoIt3Wrapper_GUI ****
#include <GuiConstantsEx.au3>
#include <WindowsConstants.au3>
#include <GuiTreeView.au3>
#include <File.au3>
#include <APIConstants.au3>
#include <WinAPIEx.au3>
#include 'IniVirtual v0.6.au3'

Global $i_DH_X, $i_DH_Y, $i_DH_Width, $i_DH_Height
Global $a_Ini_Main2D[1][2]
Global $h_ClickedItemTV
Global $s_Main_HelpIni = @ScriptDir & '\DH.ini'
Global $i_OutputFormat;	     __DH_WinGetPos
Global $i_ShowRegiones;	     __DH_WinGetPos
Global $s_OriginalFile = IniRead($s_Main_HelpIni, '_HELP FILES', 'Active', '')

If Not $s_OriginalFile Then
	$var = FileOpenDialog('  ', @ProgramFilesDir & '\AutoIt3\Include', "(*.au3)", 1 )
	If @error Then
		Exit
	Else
		IniWrite($s_Main_HelpIni, '_HELP FILES', 'Active', $var)
		$s_OriginalFile = $var
	EndIf
EndIf


Global $s_FileText = FileRead($s_OriginalFile)
_Strip_CommentBlocks($s_FileText)
_Strip_EmptyLines($s_FileText)

__DH_WinGetPos($i_DH_X, $i_DH_Y, $i_DH_Width, $i_DH_Height)
$h_Help = GUICreate($s_Main_HelpIni, $i_DH_Width, $i_DH_Height, $i_DH_X, $i_DH_Y, $DS_SETFOREGROUND + $WS_VISIBLE + $WS_OVERLAPPEDWINDOW)
GUISetBkColor(0xDCDAC1, $h_Help)

$id_File = GUICtrlCreateMenu("&File")
$id_AddUDF = GUICtrlCreateMenuItem(" UDF", $id_File)
$id_AddDir = GUICtrlCreateMenuItem(" ", $id_File)
GUICtrlCreateMenuItem('', $id_File)
$id_Del = GUICtrlCreateMenuItem(" /", $id_File)

$id_Options = GUICtrlCreateMenu("Options")
$id_ShowWithRegions = GUICtrlCreateMenuItem("  ", $id_Options)
If $i_ShowRegiones = 1 Then GUICtrlSetState($id_ShowWithRegions, $GUI_CHECKED)
GUICtrlCreateMenuItem('', $id_Options)
$id_ShowHeader = GUICtrlCreateMenuItem(" ", $id_Options, -1, 1)
$id_ShowFunc = GUICtrlCreateMenuItem(" ", $id_Options, -1, 1)
$id_ShowFrame = GUICtrlCreateMenuItem("  + ", $id_Options, -1, 1)

GUICtrlSetState($id_ShowHeader + $i_OutputFormat - 1, $GUI_CHECKED)
$id_Info = GUICtrlCreateMenuItem("Info", -1)

$_Lab_Tittle = GUICtrlCreateLabel('D i n a m i c   H e l p   0.5', 2, 0, $i_DH_Width - 257, 20, 0x01)
GUICtrlSetColor(-1, 0x0000FF)
GUICtrlSetFont(-1, 14, 700, 0)
GUICtrlSetResizing(-1, $GUI_DOCKRIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKHEIGHT)
GUICtrlSetBkColor(-1, 0xCCD8E1)

$h_Edit_Help = GUICtrlCreateEdit(_DH_HelpInfo(), 2, 22, $i_DH_Width - 253, $i_DH_Height - 63)
GUICtrlSetResizing(-1, $GUI_DOCKRIGHT + $GUI_DOCKLEFT + $GUI_DOCKTOP + $GUI_DOCKBOTTOM)
GUICtrlSetColor(-1, 0x000090)
GUICtrlSetFont(-1, 9, 400, 0, "Courier New")
GUICtrlSetBkColor(-1, 0xF0F4F9)

$_Lab_Help = GUICtrlCreateLabel(__DH_Get_Name($s_OriginalFile), $i_DH_Width - 245, 0, 242, 20, 0x1000 + 0x01)
GUICtrlSetBkColor(-1, 0xDCDAC1)
GUICtrlSetColor(-1, 0xFF0000)
GUICtrlSetResizing(-1, $GUI_DOCKRIGHT + $GUI_DOCKSIZE + $GUI_DOCKTOP)
$i_Style = BitOR($TVS_HASBUTTONS, $TVS_HASLINES, $TVS_LINESATROOT, $TVS_DISABLEDRAGDROP, $TVS_SHOWSELALWAYS)
$h_TV_Help = GUICtrlCreateTreeView($i_DH_Width - 246, 22, 242, $i_DH_Height - 63, $i_Style, $WS_EX_CLIENTEDGE)
GUICtrlSetResizing(-1, $GUI_DOCKRIGHT + $GUI_DOCKWIDTH + $GUI_DOCKTOP + $GUI_DOCKBOTTOM)
GUICtrlSetBkColor(-1, 0xCBE8F6)
$h_ImageList = __DH_ImageList_Create($h_TV_Help)
$h_Item = _GUICtrlTreeView_Add($h_TV_Help, 0, 'Dinamic Help', 1, 1)

$_Lab_Status = GUICtrlCreateLabel('', 2, $i_DH_Height - 40, $i_DH_Width - 4, 20, 0x1000)
GUICtrlSetResizing(-1, $GUI_DOCKLEFT + $GUI_DOCKRIGHT + $GUI_DOCKHEIGHT + $GUI_DOCKBOTTOM)
GUICtrlSetColor(-1, 0xAA0000)

$_Lab_Resize = GUICtrlCreateLabel('', $i_DH_Width - 250, 2, 4, $i_DH_Height - 43, 0x1000)
GUICtrlSetResizing(-1, $GUI_DOCKRIGHT + $GUI_DOCKWIDTH + $GUI_DOCKTOP + $GUI_DOCKBOTTOM)
GUICtrlSetBkColor(-1, 0x0000C0)
GUICtrlSetCursor(-1, 13)

If $i_ShowRegiones = 1 Then
	__DH_Set_VirtualIni($s_OriginalFile, $a_Ini_Main2D)
Else
	__DH_Set_VirtualIni_Noregion($s_OriginalFile, $a_Ini_Main2D)
EndIf
__DH_Update_TreeView($h_Item)

GUIRegisterMsg($WM_NOTIFY, "__DH_WM_NOTIFY")
GUISetState()

While 1
	$nMsg = GUIGetMsg()
	Switch $nMsg
		Case $GUI_EVENT_CLOSE
			_DH_Close_HelpWindow($h_Help)
		Case $id_AddUDF
			_DH_Ini_AddFile()
		Case $id_AddDir
			_DH_Ini_AddDir()
		Case $id_Del
			_DH_Ini_DelFile()
		Case $id_Info
			GUICtrlSetData($h_Edit_Help, _DH_HelpInfo())
		Case $id_ShowHeader To $id_ShowFrame
			$i_OutputFormat = ($nMsg - $id_ShowHeader + 1)
			__DH_SetEdit($h_TV_Help, $h_ClickedItemTV)
		Case $id_ShowWithRegions
			__DH_SwitchNoregion(GUICtrlRead($nMsg))
		Case $_Lab_Resize
			_DH_ControlResizing($h_Help, $_Lab_Resize)
	EndSwitch
WEnd

#region Basic Functions
;~ -	_DH_Close_HelpWindow		- 	  Help
;~ - 	_DH_ControlResizing		- 	 ,   Resize-
;~ -	_DH_Ini_AddFile			-      -
;~ - 	_DH_Ini_AddDir				- 	   -
;~ -	_DH_Ini_DelFile			-      -
;~ -	_DH_HelpInfo				-      

;=============================================================
;  Help
;=============================================================
Func _DH_Close_HelpWindow($hWnd)
	__DH_Exit_Save_Ini($hWnd)
	Exit
EndFunc   ;==>_DH_Close_HelpWindow

;=============================================================
; ,   Resize-
;=============================================================
Func _DH_ControlResizing($hWnd, $ResLab)
	Local $iPos, $wEdit, $xTv, $wTv
	Local $iMouseCursor = MouseGetCursor()

	Local $hDC = _WinAPI_GetDC(GUICtrlGetHandle($ResLab))
	Local $Color = _WinAPI_GetPixel($hDC, 0, 0)
	_WinAPI_ReleaseDC($hWnd, $hDC)
	GUICtrlSetBkColor($ResLab, 0xFFFF00)

	Local $iWidth = _WinAPI_GetClientWidth($hWnd)
	Local $aCur_Info = GUIGetCursorInfo($hWnd)
	Local $aLab_Pos = ControlGetPos($hWnd, '', $ResLab)
	If @error Then Return

	Local $dX = $aLab_Pos[0] - $aCur_Info[0]

	While $aCur_Info[2] = 1
		$aCur_Info = GUIGetCursorInfo($hWnd)
		If $iMouseCursor = 13 Then
			$iPos = $aCur_Info[0] + $dX
			If $iPos <= 230 Or $iPos >= $iWidth - 130 Then ContinueLoop
			$wEdit = $iPos - 2 - 1
			$xTv = $iPos + 4
			$wTv = $iWidth - $xTv - 1
			GUICtrlSetPos($ResLab, $iPos, Default)
			GUICtrlSetPos($h_Edit_Help, Default, Default, $wEdit)
			GUICtrlSetPos($_Lab_Tittle, Default, Default, $wEdit)
			GUICtrlSetPos($_Lab_Help, $xTv, Default, $wTv)
			GUICtrlSetPos($h_TV_Help, $xTv, Default, $wTv)
		EndIf
	WEnd

	GUICtrlSetBkColor($ResLab, $Color)
EndFunc   ;==>_DH_ControlResizing

;=======================================
;     -
;=======================================
Func _DH_Ini_AddFile()
	Local $aFile = _WinAPI_GetOpenFileName(" () ()", " AutoIt(*.au3)", ".", @ScriptName, "", 1, BitOR($OFN_ALLOWMULTISELECT, $OFN_EXPLORER), 0, $h_Help)
	If $aFile[0] = 0 Then Return SetError(1)
	For $i = 2 To $aFile[0]
		$sFile = $aFile[1] & '\' & $aFile[$i]
		If $sFile <> $s_OriginalFile And _IniVirtual_Read($a_Ini_Main2D, '_HELP FILES', 'Active', '') <> $sFile Then
			IniWrite($s_Main_HelpIni, '_HELP FILES', __DH_Get_Name($sFile), $sFile)
			_IniVirtual_Write($a_Ini_Main2D, '_HELP FILES', __DH_Get_Name($sFile), $sFile)
		EndIf
	Next
	__DH_Update_TreeView('', __DH_Get_Name($sFile))
EndFunc   ;==>_DH_Ini_AddFile

;=======================================
;    -
;=======================================
Func _DH_Ini_AddDir()
	$var = FileSelectFolder('   UDF', '', 2, @ScriptDir, $h_Help)
	If Not @error Then
		$aFilelist = _FileListToArray($var, '*.au3')
		If @error Then
			MsgBox(64 + 4096, 'Info', '   Au3- ', 1)
			Return
		EndIf
		IniWrite($s_Main_HelpIni, '_HELP FILES', __DH_Get_Name($var), $var)
		_IniVirtual_Write($a_Ini_Main2D, '_HELP FILES', __DH_Get_Name($var), $var)
		__DH_Update_TreeView('', __DH_Get_Name($var))
	EndIf
EndFunc   ;==>_DH_Ini_AddDir

;===============================================================
;    -
;===============================================================
Func _DH_Ini_DelFile()
	Local $sTree, $aTree, $sPath
	If _GUICtrlTreeView_GetText($h_TV_Help, $h_ClickedItemTV) = 'Active' Then
		Return MsgBox(64 + 4096, 'Info', '   ', 1)
	EndIf
	$sTree = _GUICtrlTreeView_GetTree($h_TV_Help, $h_ClickedItemTV)
	$aTree = StringSplit($sTree, "|")
	If $aTree[0] = 3 And $aTree[2] = '_HELP FILES' Then
		$sPath = _IniVirtual_Read($a_Ini_Main2D, '_HELP FILES', $aTree[3], '')
		If MsgBox(36 + 4096, 'Question', ' UDF : ' & @CRLF & $sPath) = 6 Then
			IniDelete($s_Main_HelpIni, '_HELP FILES', $aTree[3])
			_IniVirtual_Delete($a_Ini_Main2D, '_HELP FILES', $aTree[3])
			__DH_Update_TreeView()
		EndIf
	ElseIf $aTree[0] = 4 Then
		_GUICtrlTreeView_Delete($h_TV_Help, $h_ClickedItemTV)
	EndIf
EndFunc   ;==>_DH_Ini_DelFile

;===============================================================
;    
;===============================================================
Func _DH_HelpInfo()
	Local $sText = '-         .' & @CRLF & _
			'	        .' & @CRLF & _
			'	         .' & @CRLF & _
			'	  , -    : NoRegion  NoRegionInclude' & @CRLF & _
			@CRLF & _
			'-   : "    "      (   -  )' & @CRLF & _
			@CRLF & _
			'-   : " UDF"  " "    - /, ' & @CRLF & _
			'    -.' & @CRLF & _
			@CRLF & _
			'-   : " ", " "  "   "'  & @CRLF &  _
			'	    . ' & @CRLF & _
			@CRLF & _
			'-   : " UDF"    /   -.' & @CRLF & _
			@CRLF & _
			'-        Include   .' & @CRLF & _
			'-        Include       ( _HELP FILES).' & @CRLF & _
			@CRLF & _
			'-        _HELP FILES   .' & @CRLF & _
			'-        _HELP FILES       ' & @CRLF & _
			@CRLF & _
			'-          ,    : "Options" ' & @CRLF & _
			@CRLF & _
			'	:       '
	Return $sText
EndFunc   ;==>_DH_HelpInfo
#endregion Basic Functions



#region Auxiliary Functions
;~ - __DH_Del_CommentBlocks			-   
;~ - __DH_Exit_Save_Ini					-      Help
;~ - __DH_Get_Frame						-   (   )
;~ - __DH_Get_Func						-   
;~ - __DH_Get_FuncHeader				-    () 
;~ - __DH_Get_ItemHandle				-     TreeView
;~ - __DH_Get_Region						-   -
;~ - __DH_Get_TextFagment				-    
;~ - __DH_SetEdit							-     Edit
;~ - __DH_Set_VirtualIni				-     -
;~ - __DH_Set_VirtualIni_Noregion	-     -  
;~ - __DH_SwitchNoregion				-      
;~ - __DH_Update_1						-   *** New
;~ - __DH_Update_TreeView				-   
;~ - __DH_WinGetPos						-       Help
;~ - __DH_WM_NOTIFY						-    TreeView


;=============================================================
;     Help
;=============================================================
Func __DH_Exit_Save_Ini($hWnd)
	If BitAND(WinGetState($hWnd), 32) Then
		WinSetState($hWnd, "", @SW_RESTORE)
	EndIf
	Local $aPos = WinGetPos($hWnd)
	Local $aClient = WinGetClientSize($hWnd)
	IniWrite($s_Main_HelpIni, 'Settings', 'X', $aPos[0])
	IniWrite($s_Main_HelpIni, 'Settings', 'Y', $aPos[1])
	IniWrite($s_Main_HelpIni, 'Settings', 'W', $aClient[0])
	IniWrite($s_Main_HelpIni, 'Settings', 'H', $aClient[1] + 20)
	IniWrite($s_Main_HelpIni, 'Settings', 'Opt OutputFormat', $i_OutputFormat)
	IniWrite($s_Main_HelpIni, 'Settings', 'Opt ShowRegiones', $i_ShowRegiones)
EndFunc   ;==>__DH_Exit_Save_Ini

;=======================================
;   (   )
;=======================================
Func __DH_Get_Frame($sText, $hTV, $hItemTV)
	Local $sFuncName = _GUICtrlTreeView_GetText($hTV, $hItemTV)
	Local $aReturn = StringRegExp($sText, '(?msi)((?:^;[^\n]*\n)*\v{0,3}^\h*Func\h*\Q' & $sFuncName & '\E\h*\(.*?^\h*EndFunc.*?)$', 1)
	If @error Then Return 0
	Return $aReturn[0]
EndFunc   ;==>__DH_Get_Frame

;=======================================
;   
;=======================================
Func __DH_Get_Func($sText, $hTV, $hItemTV)
	Local $sFuncName = _GUICtrlTreeView_GetText($hTV, $hItemTV)
	Local $aReturn = StringRegExp($sText, '(?msi)(^\h*Func\h*\Q' & $sFuncName & '\E\h*\(.*?^\h*EndFunc.*?)$', 1)
	If @error Then Return 0
	Return $aReturn[0]
EndFunc   ;==>__DH_Get_Func

;=======================================
;    () 
;=======================================
Func __DH_Get_FuncHeader($sText, $hTV, $hItemTV)
	Local $sFuncName = _GUICtrlTreeView_GetText($hTV, $hItemTV)
	Local $aReturn = StringRegExp($sText, '(?smi)((?:^;[^\n]*\n)*\v{0,3}^\h*Func\h*\Q' & $sFuncName & '\E\h*\([^\n]*\n).*?^\h*(Return\h*;?[^\n]*?\n)?(?:^;[^\n]*?\n)*^\h*(EndFunc\h*;?[^\n]*?)$', 1)
	If @error Then Return 0
	Return $aReturn[0] & '  . . .  ' & @CRLF & $aReturn[1] & $aReturn[2]
EndFunc   ;==>__DH_Get_FuncHeader

;=========================================================================
;     TreeView
;=========================================================================
Func __DH_Get_ItemHandle($hTV)
	$tPoint = _WinAPI_GetMousePos(1, $hTV)
	$tTVHTI = _GUICtrlTreeView_HitTestEx($hTV, DllStructGetData($tPoint, 1), DllStructGetData($tPoint, 2))
	$hItem = DllStructGetData($tTVHTI, 'Item')
	Return $hItem
EndFunc   ;==>__DH_Get_ItemHandle

;=======================================
;   -
;=======================================
Func __DH_Get_Region($sText, $hTV, $hItemTV)
	Local $sSection = _GUICtrlTreeView_GetText($hTV, $hItemTV)
	If $sSection = '_HELP FILES' Then Return
	Local $aReturn = StringRegExp($sText, '(?msi)(^\h*#Region\h*' & $sSection & '(?:\h*;\h*)?\r\n.*?^\h*#EndRegion.*?)$', 1)
	If @error Then Return 0
	Return $aReturn[0]
EndFunc   ;==>__DH_Get_Region

;=======================================
;    
;=======================================
Func __DH_Get_TextFagment($hTV, $hItem, $sFileText, $iFlag)
	Local $sText
	Switch $iFlag
		Case 1 ; Header
			$sText = __DH_Get_FuncHeader($sFileText, $hTV, $hItem)
		Case 2 ; Func
			$sText = __DH_Get_Func($sFileText, $hTV, $hItem)
		Case 3 ; All
			$sText = __DH_Get_Frame($sFileText, $hTV, $hItem)
		Case 4 ; Region
			$sText = __DH_Get_Region($sFileText, $hTV, $hItem)
	EndSwitch
	Return $sText
EndFunc   ;==>__DH_Get_TextFagment

;=======================================
;     Edit
;=======================================
Func __DH_SetEdit($hTV, $hItem = '')
	Local $sText
	$sTree = _GUICtrlTreeView_GetTree($hTV, $hItem)
	$aTree = StringSplit($sTree, "|")
	If $aTree[0] = 4 Then ; 
		$sPath = _IniVirtual_Read($a_Ini_Main2D, $aTree[2], $aTree[3], '') & '\' & $aTree[4]
		If FileExists($sPath) Then
			$sText = FileRead($sPath)
		EndIf
	ElseIf $aTree[0] = 3 Then ;
		$sPath = _IniVirtual_Read($a_Ini_Main2D, $aTree[2], $aTree[3], '')
		If $sPath = 1 Then
			If $i_OutputFormat = 4 Then
				$hItem = _GUICtrlTreeView_GetParentHandle($hTV, $hItem)
			EndIf
			$sText = __DH_Get_TextFagment($hTV, $hItem, $s_FileText, $i_OutputFormat)
		ElseIf FileExists($sPath) Then
			$sText = FileRead($sPath)
		EndIf
		If FileExists($sPath) Then
			GUICtrlSetData($_Lab_Status, $sPath)
		EndIf
	ElseIf $aTree[0] = 2 Then ; 
		$sText = __DH_Get_TextFagment($hTV, $hItem, $s_FileText, 4)
	EndIf
	GUICtrlSetData($h_Edit_Help, $sText)
EndFunc   ;==>__DH_SetEdit

;=======================================
;     -
;=======================================
Func __DH_Set_VirtualIni($sFileAu3, ByRef $aIni2D)
	Local $aSection, $sRegion, $sLine, $sStr, $sFileInclude, $Func
	Local $sUdf_Path = __DH_Get_Path($sFileAu3)

	If UBound($aIni2D) = 1 Then
		$aSection = IniReadSection($s_Main_HelpIni, '_HELP FILES');
	Else
		$aSection = _IniVirtual_ReadSection($a_Ini_Main2D, '_HELP FILES')
	EndIf
	Dim $aIni2D[1][2];  
	_IniVirtual_WriteSection($aIni2D, '_HELP FILES', $aSection, 1);      

	Local $hFile = FileOpen($sFileAu3, 0)
	$Scip = False
	If $hFile = -1 Then
		MsgBox(4096, "", "  : " & @CRLF & $sFileAu3 & @CRLF & "  .")
		Return
	EndIf

	While 1
		$sLine = FileReadLine($hFile)
		If @error = -1 Then ExitLoop
		If StringRegExp($sLine, '(?i)^\h*#cs') Then
			$Scip = True
		ElseIf StringRegExp($sLine, '(?i)^\h*#ce') Then
			$Scip = False
		EndIf
		If $Scip = True Then ContinueLoop

		$sStr = StringRegExpReplace($sLine, '(?i)^\h*#region\h*(.*)$', '$1')
		If @extended Then
			$sRegion = $sStr
		EndIf
		$sStr = StringRegExpReplace($sLine, '(?i)^\h*#Endregion\h*(.*)$', '$1')
		If @extended Then
			$sRegion = ''
		EndIf
		$sStr = StringRegExpReplace($sLine, "(?i)^\h*#include\h*[<'""]\h*(.*\.au3)\h*[>'""]\h*$", '$1')
		If @extended Then
			If StringInStr($sStr, '<') Then ;AutoIt Dir
				$sFileInclude = @ProgramFilesDir & '\AutoIt3\Include\' & $sStr
				If Not FileExists($sFileInclude) Then
					$sFileInclude = @ScriptDir & '\' & $sStr
				EndIf
			Else; UDF Dir
				If FileExists($sStr) Then
					$sFileInclude = $sStr
				Else
					$sFileInclude = StringReplace($sStr, '..\', __DH_Get_Path($sUdf_Path) & '\')
					If @extended = 0 Then
						$sFileInclude = $sUdf_Path & '\' & $sStr
					EndIf
				EndIf
				If Not FileExists($sFileInclude) Then
					$sFile = @ProgramFilesDir & '\AutoIt3\Include\' & $sStr
					If FileExists($sFile) Then
						$sFileInclude = $sFile
					EndIf
				EndIf
			EndIf
			If Not $sRegion Then
				$sRegion = 'NoRegionInclude'
			EndIf
			_IniVirtual_Write($aIni2D, $sRegion, __DH_Get_Name($sFileInclude), $sFileInclude)
		EndIf
		$sStr = StringRegExpReplace($sLine, '(?i)^\h*func\h*(.*)\(.*$', '$1')
		If @extended Then
			If Not $sRegion Or $sRegion = 'NoRegionInclude' Then
				$sRegion = 'NoRegion'
			EndIf
			_IniVirtual_Write($aIni2D, $sRegion, $sStr, 1)
		EndIf
	WEnd
	FileClose($hFile)
EndFunc   ;==>__DH_Set_VirtualIni

;===============================================================
;     -  
;===============================================================
Func __DH_Set_VirtualIni_Noregion($sFileAu3, ByRef $aIni2D)
	Local $aSection, $sRegion, $sLine, $sStr, $sFileInclude, $Func
	Local $sUdf_Path = __DH_Get_Path($sFileAu3)

	If UBound($aIni2D) = 1 Then
		$aSection = IniReadSection($s_Main_HelpIni, '_HELP FILES')
	Else
		$aSection = _IniVirtual_ReadSection($a_Ini_Main2D, '_HELP FILES')
	EndIf
	Dim $aIni2D[1][2];  
	_IniVirtual_WriteSection($aIni2D, '_HELP FILES', $aSection, 1);      

	Local $hFile = FileOpen($sFileAu3, 0)
	$Scip = False
	If $hFile = -1 Then
		MsgBox(4096, "", "  : " & @CRLF & $sFileAu3 & @CRLF & "  .")
		Return
	EndIf

	While 1
		$sLine = FileReadLine($hFile)
		If @error = -1 Then ExitLoop
		If StringRegExp($sLine, '(?i)^\h*#cs') Then
			$Scip = True
		ElseIf StringRegExp($sLine, '(?i)^\h*#ce') Then
			$Scip = False
		EndIf
		If $Scip = True Then ContinueLoop

		$sStr = StringRegExpReplace($sLine, "(?i)^\h*#include\h*[<'""]\h*(.*\.au3)\h*[>'""]\h*$", '$1')
		If @extended Then
			If StringInStr($sStr, '<') Then ;AutoIt Dir
				$sFileInclude = @ProgramFilesDir & '\AutoIt3\Include\' & $sStr
				If Not FileExists($sFileInclude) Then
					$sFileInclude = @ScriptDir & '\' & $sStr
				EndIf
			Else; UDF Dir
				If FileExists($sStr) Then
					$sFileInclude = $sStr
				Else
					$sFileInclude = StringReplace($sStr, '..\', __DH_Get_Path($sUdf_Path) & '\')
					If @extended = 0 Then
						$sFileInclude = $sUdf_Path & '\' & $sStr
					EndIf
				EndIf
				If Not FileExists($sFileInclude) Then
					$sFile = @ProgramFilesDir & '\AutoIt3\Include\' & $sStr
					If FileExists($sFile) Then
						$sFileInclude = $sFile
					EndIf
				EndIf
			EndIf
			If Not $sRegion Then
				$sRegion = 'NoRegionInclude'
			EndIf
			_IniVirtual_Write($aIni2D, $sRegion, __DH_Get_Name($sFileInclude), $sFileInclude)
		EndIf
		$sStr = StringRegExpReplace($sLine, '(?i)^\h*func\h*(.*)\(.*$', '$1')
		If @extended Then
			$sRegion = 'All Func'
			_IniVirtual_Write($aIni2D, $sRegion, $sStr, 1)
		EndIf
	WEnd
	FileClose($hFile)
EndFunc   ;==>__DH_Set_VirtualIni_Noregion

;=======================================
;       
;=======================================
Func __DH_SwitchNoregion($iFlag)
	Local $sCurrentFilePath = _IniVirtual_Read($a_Ini_Main2D, '_HELP FILES', 'Active', '')
	If Not $sCurrentFilePath Then
		Return MsgBox(16 + 4096, 'Error', '  ', 1)
	EndIf
	If $i_OutputFormat = 4 Then
		$i_OutputFormat = 1
		GUICtrlSetState($id_ShowHeader, $GUI_CHECKED)
	EndIf
	If BitAND($iFlag, $GUI_CHECKED) = $GUI_CHECKED Then
		$i_ShowRegiones = 0
		GUICtrlSetState($id_ShowWithRegions, $GUI_UnCHECKED)
		__DH_Set_VirtualIni_Noregion($sCurrentFilePath, $a_Ini_Main2D)
	Else
		$i_ShowRegiones = 1
		GUICtrlSetState($id_ShowWithRegions, $GUI_CHECKED)
		__DH_Set_VirtualIni($sCurrentFilePath, $a_Ini_Main2D)
	EndIf
	__DH_Update_TreeView()
EndFunc   ;==>__DH_SwitchNoregion

;============================================================================
;   
;============================================================================
Func __DH_Update_TreeView($hFirstItem = '', $sSelect = 'Active')
	Local $hSect, $aData, $hChild, $hExpand, $iIcon
	If Not $hFirstItem Then
		$hFirstItem = _GUICtrlTreeView_GetFirstItem($h_TV_Help)
	EndIf
	_GUICtrlTreeView_BeginUpdate($h_TV_Help)
	_GUICtrlTreeView_DeleteChildren($h_TV_Help, $hFirstItem)
	For $i = 1 To UBound($a_Ini_Main2D) - 1
		$hSect = _GUICtrlTreeView_AddChild($h_TV_Help, $hFirstItem, $a_Ini_Main2D[$i][0], 2, 2)
		$aData = $a_Ini_Main2D[$i][1]
		For $j = 1 To UBound($aData) - 1
			If StringInStr(FileGetAttrib($aData[$j][1]), "D") Then
				$iIcon = 4; 
			ElseIf FileExists($aData[$j][1]) Then
				$iIcon = 5;  AutoIt
			ElseIf $aData[$j][1] = 1 Then
				$iIcon = 3;  -
			Else
				$iIcon = 0;  
			EndIf
			$hChild = _GUICtrlTreeView_AddChild($h_TV_Help, $hSect, $aData[$j][0], $iIcon, $iIcon)
			If StringInStr(FileGetAttrib($aData[$j][1]), "D") Then
				$iIcon = 5;  AutoIt
				Local $aFilelist = _FileListToArray($aData[$j][1], '*.au3')
				If @error Then
					Return SetError(1)
				EndIf
				For $jj = 1 To UBound($aFilelist) - 1
					_GUICtrlTreeView_AddChild($h_TV_Help, $hChild, $aFilelist[$jj], $iIcon, $iIcon)
				Next
			EndIf
		Next
	Next
	_GUICtrlTreeView_EndUpdate($h_TV_Help)
	;_GUICtrlTreeView_SelectItem($h_TV_Help, $hFirstItem)
	$hSelect = _GUICtrlTreeView_FindItem($h_TV_Help, $sSelect)
	_GUICtrlTreeView_SelectItem($h_TV_Help, $hSelect)
	;$hExpand=_GUICtrlTreeView_FindItem($h_TV_Help, '_HELP FILES')
	;_GUICtrlTreeView_Expand($h_TV_Help, $hExpand)
EndFunc   ;==>__DH_Update_TreeView

;============================================================================
;  
;============================================================================
Func __DH_Update(ByRef $aIni2D, $hTV, $hItem)
	Local $sFile, $sItemText, $sParent, $sRead, $sFile, $sDefaultPath, $sSel
	$sItemText = _GUICtrlTreeView_GetText($hTV, $hItem)
	If $sItemText = 'Active' Then Return
	$sParent = _GUICtrlTreeView_GetText($hTV, _GUICtrlTreeView_GetParentHandle($hTV, $hItem))
	$sRead = _IniVirtual_Read($aIni2D, '_HELP FILES', $sParent, '')
	If $sRead Then ; 
		$sFile = $sRead & '\' & $sItemText
		$sSel = $sItemText
	Else
		$sRead= _IniVirtual_Read($aIni2D, $sParent, $sItemText, '')
		If Not StringInStr(FileGetAttrib($sRead), "D") Then
			$sFile = $sRead
			$sSel = 'Active'
		EndIf
	EndIf
	If Not FileExists($sFile) Then Return

	If $i_ShowRegiones = 0 Then
		__DH_Set_VirtualIni_Noregion($sFile, $aIni2D);    -  
	Else
		__DH_Set_VirtualIni($sFile, $aIni2D);    -
	EndIf

	If $sSel = 'Active' Then
		$sDefaultPath = _IniVirtual_Read($aIni2D, '_HELP FILES', 'Active', '');       
		_IniVirtual_Write($aIni2D, '_HELP FILES', 'Active', $sFile)
		_IniVirtual_Write($aIni2D, '_HELP FILES', __DH_Get_Name($sDefaultPath), $sDefaultPath)
		_IniVirtual_Delete($aIni2D, '_HELP FILES', $sItemText)
	EndIf
	GUICtrlSetData($_Lab_Help, $sItemText)
	$s_FileText = FileRead($sFile);    -

	_Strip_CommentBlocks($s_FileText)
	_Strip_EmptyLines($s_FileText)

	__DH_Update_TreeView('', $sSel)
EndFunc   ;==>__DH_Update

;=============================================================
;      Help
;=============================================================
Func __DH_WinGetPos(ByRef $iX, ByRef $iY, ByRef $iW, ByRef $iH)
	$iX = IniRead($s_Main_HelpIni, 'Settings', 'X', -1)
	$iY = IniRead($s_Main_HelpIni, 'Settings', 'Y', -1)
	$iW = Number(IniRead($s_Main_HelpIni, 'Settings', 'W', '780'))
	$iH = Number(IniRead($s_Main_HelpIni, 'Settings', 'H', '520'))
	$i_OutputFormat = IniRead($s_Main_HelpIni, 'Settings', 'Opt OutputFormat', 3)
	$i_ShowRegiones = IniRead($s_Main_HelpIni, 'Settings', 'Opt ShowRegiones', 1)
EndFunc   ;==>__DH_WinGetPos

;=============================================================
;    TreeView
;=============================================================
Func __DH_WM_NOTIFY($hWnd, $iMsg, $iwParam, $ilParam)
	#forceref $hWnd, $iMsg, $iwParam
	Local $hWndFrom, $iIDFrom, $iCode, $tNMHDR, $hWndTreeview, $hClickedItemTV
	Local $sItemText, $sSection
	$hWndTreeview = $h_TV_Help
	If Not IsHWnd($h_TV_Help) Then $hWndTreeview = GUICtrlGetHandle($h_TV_Help)

	$tNMHDR = DllStructCreate($tagNMHDR, $ilParam)
	$hWndFrom = HWnd(DllStructGetData($tNMHDR, "hWndFrom"))
	$iIDFrom = DllStructGetData($tNMHDR, "IDFrom")
	$iCode = DllStructGetData($tNMHDR, "Code")
	Switch $hWndFrom
		Case $hWndTreeview
			Switch $iCode
				Case $NM_CLICK
					$h_ClickedItemTV = __DH_Get_ItemHandle($hWndFrom)
					If $h_ClickedItemTV Then
						__DH_SetEdit($hWndFrom, $h_ClickedItemTV)
					EndIf
				Case $NM_DBLCLK
					$hClickedItemTV = __DH_Get_ItemHandle($hWndFrom)
					__DH_Update($a_Ini_Main2D, $hWndFrom, $hClickedItemTV)
			EndSwitch
	EndSwitch
	Return $GUI_RUNDEFMSG
EndFunc   ;==>__DH_WM_NOTIFY
#endregion Auxiliary Functions


#region Helper Functions
;~ - __DH_Get_Icon
;~ - __DH_ImageList_Create
;~ - __DH_Get_Name
;~ - __DH_Get_Path
;~ - __DH_GetText_VirtualIni
;~ - _Strip_CommentBlocks
;~ - _Strip_EmptyLines

;================================================================
;   ImageList,  
;================================================================
Func __DH_Get_Icon($hImage, $sPath); *** New
	$hIcon = _WinAPI_ShellExtractAssociatedIcon($sPath, 1)
	$Index = _GUIImageList_ReplaceIcon($hImage, -1, $hIcon)
	_WinAPI_DestroyIcon($hIcon)
	Return $Index
EndFunc   ;==>__DH_Get_Icon

;================================================================
; ImageList   TreeView
;================================================================
Func __DH_ImageList_Create($hTV)
	If Not IsHWnd($hTV) Then
		$hTV = GUICtrlGetHandle($hTV)
	EndIf
	Local $hImageList = _GUIImageList_Create(16, 16, 5, 1)
	_GUIImageList_AddIcon($hImageList, @SystemDir & '\shell32.dll', 0)
	_GUIImageList_AddIcon($hImageList, @SystemDir & '\shell32.dll', 43); 1--
	_GUIImageList_AddIcon($hImageList, @SystemDir & '\shell32.dll', 33); 2-  -
	_GUIImageList_AddIcon($hImageList, @SystemDir & '\shell32.dll', 282); 3- -
	_GUIImageList_AddIcon($hImageList, @SystemDir & '\shell32.dll', 3) ; 4-
	__DH_Get_Icon($hImageList, @ProgramFilesDir & '\AutIt3\Include\Color.au3') ; 5- AutoIt
	_GUICtrlTreeView_SetNormalImageList($hTV, $hImageList)
	Return $hImageList
EndFunc   ;==>__DH_ImageList_Create

;=========================================
;     
;   
;=========================================
Func __DH_Get_Name($sPath)
	$sPatern = "^.*\\(.*)"
	$sResult = StringRegExpReplace($sPath, $sPatern, '$1')
	Return $sResult
EndFunc   ;==>__DH_Get_Name

;=========================================
;     
;=========================================
Func __DH_Get_Path($sPath)
	$sPatern = "\\[^\\]*$"
	$sResult = StringRegExpReplace($sPath, $sPatern, '')
	If @extended = 0 Then Return ''
	Return $sResult
EndFunc   ;==>__DH_Get_Path

;================================================================
;     
;================================================================
Func __DH_GetText_VirtualIni($aArray2D)
	Local $sRet = '', $aData
	For $i = 1 To UBound($aArray2D) - 1
		$sRet &= '[' & $aArray2D[$i][0] & ']' & @CRLF
		$aData = $aArray2D[$i][1]
		For $j = 1 To UBound($aData) - 1
			$sRet &= $aData[$j][0] & '=' & $aData[$j][1] & @CRLF
		Next
	Next
	Return StringTrimRight($sRet, 1)
EndFunc   ;==>__DH_GetText_VirtualIni

;=======================================
;   
; by By Robjong
;=======================================
Func _Strip_CommentBlocks(ByRef $sData, $sReplace = Default)
	If $sReplace = Default Then
		$sReplace = ''
	EndIf
	$sData = StringRegExpReplace($sData, '(?ims:^#(?:cs|comments-start)(?!\w).+?#(?:ce|comments-end)[^\r\n]*[\r\n]{1,2})', $sReplace)
EndFunc   ;==>_Strip_CommentBlocks

;=======================================
;   
;by By guinness
;=======================================
Func _Strip_EmptyLines(ByRef $sData)
	$sData = StringRegExpReplace($sData, '(?m:^\s*[\r\n])', '')
EndFunc   ;==>_Strip_EmptyLines
#endregion Helper Functions





